<?php
/*--------------------------------------------------------------
   GambioCustomersSignupsTrend.php 2021-08-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;

use Doctrine\DBAL\Connection;
use Gambio\Admin\Modules\Statistics\App\Data\Factory as DataFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory as OverviewFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined\TimespanDropdown;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Options;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

class GambioCustomersSignupsTrend extends GambioWidgetDefinition
{
    private const TYPE = 'gambio.customers.signups.trend';
    
    private const VERSION = '0.1.0';
    
    private const ICON = "data:image/png;base64,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";
    
    private const WIDGET_TITLE = [
        self::LANGUAGE_CODE_GERMAN  => 'Neukunden (Trend)',
        self::LANGUAGE_CODE_ENGLISH => 'New Customers (Trend)',
    ];
    
    private const CATEGORY_TITLE = [
        self::LANGUAGE_CODE_GERMAN  => 'Neukunden',
        self::LANGUAGE_CODE_ENGLISH => 'New Customers',
    ];
    
    /**
     * @var DataFactory
     */
    private $dataFactory;
    
    /**
     * @var UserPreferences
     */
    private $userPreferences;
    
    /**
     * @var Connection
     */
    private $connection;
    
    
    public function __construct(
        OverviewFactory $overviewFactory,
        DataFactory     $dataFactory,
        UserPreferences $userPreferences,
        Connection      $connection
    ) {
        $this->dataFactory     = $dataFactory;
        $this->userPreferences = $userPreferences;
        $this->connection      = $connection;
        
        parent::__construct($overviewFactory->createType(self::TYPE),
                            $overviewFactory->createVersion(self::VERSION),
                            $overviewFactory->createIconUsingData(self::ICON),
                            $overviewFactory->useVisualizations()->createAreaChart(),
                            $overviewFactory->useOptions()->createOptions($overviewFactory->useOptions()
                                                                              ->usePredefined()
                                                                              ->createTimespanDropdown($overviewFactory)),
                            $overviewFactory->createTitles($overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_GERMAN),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_GERMAN]),
                                                           $overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_ENGLISH),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_ENGLISH])));
    }
    
    
    public function data(Options $options): Data
    {
        $categories    = [];
        $values        = [];
        $categoryTitle = self::CATEGORY_TITLE[$this->userPreferences->languageId()
                                              == self::LANGUAGE_ID_GERMAN ? self::LANGUAGE_CODE_GERMAN : self::LANGUAGE_CODE_ENGLISH];
        $timespan      = $this->dataFactory->useTimespan()->createFromTerm($options->getById(TimespanDropdown::ID)
                                                                               ->value());
        $signups       = $this->connection->createQueryBuilder()
            ->select([
                         'count(*) AS amount',
                         'UNIX_TIMESTAMP(DATE(customers_date_added)) AS date',
                     ])
            ->from('customers')
            ->where('account_type = 0')
            ->andWhere('customers_date_added BETWEEN :startDate AND :endDate')
            ->groupBy('date')
            ->orderBy('date')
            ->setParameters([
                                ':startDate' => $timespan->startDate()->format(self::QUERY_TIMESPAN_FORMAT_DATE_START),
                                ':endDate'   => $timespan->endDate()->format(self::QUERY_TIMESPAN_FORMAT_DATE_END),
                            ])
            ->execute()
            ->fetchAll();
        
        foreach ($signups as $signup) {
            $categories[] = $this->dataFactory->useSerialData()->createCategory($signup['date']);
            $values[]     = $this->dataFactory->useSerialData()->createItemValue((int)$signup['amount']);
        }
        
        return $this->dataFactory->useSerialData()->createSerialData($this->dataFactory->useSerialData()
                                                                         ->createCategories(...$categories),
                                                                     $this->dataFactory->useSerialData()
                                                                         ->createItems($this->dataFactory->useSerialData()
                                                                                           ->createItem($this->dataFactory->useSerialData()
                                                                                                            ->createItemTitle($categoryTitle),
                                                                                                        $this->dataFactory->useSerialData()
                                                                                                            ->createItemValues(...
                                                                                                                $values))));
    }
}